IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Cbtes_Lotes_Cobranza]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Cbtes_Lotes_Cobranza] 
END
GO

CREATE PROCEDURE [dbo].[CP_Cbtes_Lotes_Cobranza]
	@pLote				VARCHAR(29),
	@pFecha				DATETIME,
	@pDescripcion		VARCHAR(50),
	@pId_Lote_Tipo		SMALLINT,
	@pId_Periodo_Caja	INT,
	@pFecha_Rec			DATETIME,
	@pId_Tipo_Cbte		CHAR(4),
	@pId_Moneda			CHAR(3),
	@pCotizacion		DECIMAL(9, 4),
	@pId_Tipo_Val		CHAR(3),
	@pImporte			DECIMAL(16,2),
	@pUsuario			INT
AS
SET NOCOUNT ON

/*Declaracion Variables Locales*/

DECLARE @Mensaje			VARCHAR(100)
		,@UltError			INT
		,@Id_Trans			INT
		,@Id_Cliente		INT
		,@Importe			DECIMAL(16,2)
		,@Email_Cob			VARCHAR(8000)
		,@Id_Trans_Rec		INT

  DECLARE @Respuesta Table (
				ErrorNumber		INT,
				ErrorSeverity	INT,
				ErrorState		INT,
				ErrorProcedure  VARCHAR(1000),
				ErrorLine		INT,
				ErrorMessage	VARCHAR(1000),
				Id_Trans		INT                       -- esto hay que sacarlo, pero antes hay que revisar en todos lados donde llama CP_Cbtes_Rec_Generar
				)




BEGIN TRY
	BEGIN TRAN

	/*Agregar Lote con fecha de inicio y [Flag_enProceso] en 1 */

	INSERT INTO Cbtes_Lotes (Lote,Fecha,Descripcion,Id_Lote_Tipo,Flag_enProceso,Fecha_Inicio)
		VALUES (@pLote,@pFecha,@pDescripcion,@pId_Lote_Tipo,1,GETDATE())



	/*Recorrer los tagueados */

	DECLARE TagCbtesCursor CURSOR FOR
		SELECT T.Ptr AS Id_Trans, CAST(T.Val AS INT) AS Id_Cliente,T.Importe , C.Email_Cob
				FROM TagFile_ T , Clientes C
				WHERE Tbl = 300 AND Usr = @pUsuario
				AND C.Id_Cliente = CAST(T.Val AS INT)

	OPEN TagCbtesCursor

	FETCH NEXT FROM TagCbtesCursor INTO @Id_Trans,@Id_Cliente,@Importe,@Email_Cob	

	WHILE @@FETCH_STATUS=0
	BEGIN
			DELETE @Respuesta
			INSERT INTO @Respuesta
			EXEC @UltError = CP_Cbtes_Rec_Generar @pUsuario, @Id_Cliente,@Email_Cob,@pId_Periodo_Caja,@pFecha_Rec,@Importe,@pId_Tipo_Cbte,@pId_Moneda,@pCotizacion,@pLote

			SELECT TOP 1 @Id_Trans_Rec = Id_Trans FROM @Respuesta

			IF @UltError <> 0 AND @Id_Trans_Rec <> 0
			BEGIN
				EXEC @UltError = CP_Cbtes_Rec_Generar_Item @Id_Trans_Rec,1,'',1,@Id_Trans,@Importe

				IF @UltError <> 0
					EXEC @UltError = CP_Cbtes_Rec_Generar_Pago @Id_Trans_Rec,@pId_Tipo_Val,0,@pFecha_Rec,@pFecha_Rec,@pFecha_Rec,@Importe,'','',NULL,'','',0

				IF @UltError <> 0
					EXEC @UltError = CP_Cbtes_Rem_Fin @Id_Trans_Rec

				IF @UltError <> 0
					EXEC @UltError = CP_Cbtes_Ctas_Contables_Generar @Id_Trans_Rec


			END
   			FETCH NEXT FROM TagCbtesCursor INTO @Id_Trans,@Id_Cliente,@Importe	

	END
	CLOSE TagCbtesCursor
	DEALLOCATE TagCbtesCursor


	/*Actualizar Lote con fecha de fin y [Flag_enProceso] en 0 y totales */
	UPDATE Cbtes_Lotes SET	Cantidad = (SELECT COUNT(*) FROM Cbtes WHERE Lote = @pLote) ,
							Importe =  (SELECT SUM(Imp_Total) FROM Cbtes WHERE Lote = @pLote),
							Fecha_Finalizacion = GETDATE(),
							Flag_enProceso = 0
			WHERE Lote = @pLote


	/******************************fin del proceso***********************************************/


	/*******************    En caso de error deberia grabar en la tablla cbtes_errores ***********************/

	
	COMMIT

	SET @Mensaje = ''

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@Mensaje		AS ErrorMessage
END TRY  


BEGIN CATCH  
    SELECT  ERROR_NUMBER() AS ErrorNumber  
		,ERROR_SEVERITY() AS ErrorSeverity  
		,ERROR_STATE() AS ErrorState  
		,ERROR_PROCEDURE() AS ErrorProcedure  
		,ERROR_LINE() AS ErrorLine  
		,ERROR_MESSAGE() AS ErrorMessage

	ROLLBACK
	UPDATE Cbtes_Lotes SET	Cantidad = (SELECT COUNT(*) FROM Cbtes WHERE Lote = @pLote) ,
							Importe =  (SELECT SUM(Imp_Total) FROM Cbtes WHERE Lote = @pLote),
							Fecha_Finalizacion = GETDATE(),
							Flag_enProceso = 0
			WHERE Lote = @pLote
	RETURN 9999
END CATCH

RETURN 0
